<?php
/*
	Plugin Name: Urbano Shipping for WooCommerce
	Plugin URI: https://www.urbano.com.ar/
	Description: Obtener costos de envío, enviar orden, etiqueta y seguimiento, por medio de API UE.
	Version: 2.0.2.6
	Author: Integrate Urbano Express
	Author URI: https://integrate.urbano.com.ar/docs/woocommerce
	WC tested up to: 3.5.3
	License: GNU General Public License v3.0
	License URI: http://www.gnu.org/licenses/gpl-3.0.html
*/


/**
 * Plugin global API URL
*/
global $wp_session;

//Accion para compatiilidad con HPOS
add_action( 'before_woocommerce_init', function() {

    if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {

        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );

    }

} );

$wp_session['url_uea'] = 'https://testing-apis.urbano.com.ar/';

require_once( 'includes/functions.php' );

/**
 * WooCommerce is active
*/
if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
	/**
	 * woocommerce_init_shipping_table_rate function.
	 *
	 * @access public
	 * @return void
	 */
	function wc_uea_init() {
		include_once( 'includes/class-wc-shipping-uea.php' );
	}
  add_action( 'woocommerce_shipping_init', 'wc_uea_init' );

	/**
	 * wc_uea_add_method function.
	 *
	 * @access public
	 * @param mixed $methods
	 * @return void
	 */
	function wc_uea_add_method( $methods ) {
		$methods[ 'uea_ueforwoocom' ] = 'WC_Shipping_Uea';
		return $methods;
	}

	add_filter( 'woocommerce_shipping_methods', 'wc_uea_add_method' );

	/**
	 * wc_uea_scripts function.
	 */
	function wc_uea_scripts() {
		wp_enqueue_script( 'jquery-ui-sortable' );
	}

	add_action( 'admin_enqueue_scripts', 'wc_uea_scripts' );

	$uea_settings = get_option( 'woocommerce_uea_settings', array() );
}