<?php
#define('WP_DEBUG', true); //borrar solo testeo
/**
 * Show info at order
 */
add_action('add_meta_boxes', 'woocommerce_uea_box_add_box');
function woocommerce_uea_box_add_box() {
    global $post;
    $transportista = get_post_meta($post->ID,'_chosen_shipping',true);
    if ($transportista == 'uea_ueforwoocom') {
        add_meta_box( 'woocommerce-uea-box', __( 'Gestion envio Urbano', 'woocommerce-uea' ), 'woocommerce_uea_box_create_box_content', 'shop_order', 'side', 'default' );
    }
}
function woocommerce_uea_box_create_box_content() {
    global $post;
    $order = wc_get_order( $post->ID );
    $origen_datos = get_post_meta($post->ID,'_origen_datos_uea',true);
    if ($origen_datos==false)
        $origen_datos = get_post_meta($post->ID,'_origen_datos',true);
    
    $origen_datos = json_decode($origen_datos,true)[0];
    $numeracion = substr($origen_datos['numeracion'], 0, 2);
    $seguimiento = $order->get_id();
    echo '<div class="urb-single" style="text-align: center">';
    $fecha_impresion = get_post_meta($post->ID,'_etiqueta_impresa',true);
    $texto_boton ='Generar Etiqueta';
    if($fecha_impresion){
        echo '<strong id="info_print">Etiqueta impresa el '.$fecha_impresion->format('d/m/Y H:i:s').'</strong>';
        $texto_boton = "Generar Etiqueta nuevamente";
    } else {
        echo '<strong id="info_print">No has impreso la etiqueta</strong>';
    }
    $datos_impresion = [
        'cli_codigo' => prefix($seguimiento,$numeracion),
        'nombre' => $order->get_formatted_shipping_full_name(),
        'calle' => $order->get_shipping_address_1().' '.$order->get_shipping_address_2(),
        'altura' =>"",
        'piso' =>"",
        'dpto' =>"",
        'cp' => $order->get_shipping_postcode(),
        'localidad' => $order->get_shipping_city(),
        'provincia' => WC()->countries->get_states($order->get_shipping_country())[$order->get_shipping_state()],
        'telefono' => $order->get_billing_phone(),
        'shipper' => $origen_datos['api_user'],
        'ciudad' => $order->get_shipping_city(),
        'observacion' => preg_replace('([^A-Za-z0-9 ])', '', $order->get_customer_note()),
    ];
    $datos_impresion = json_encode($datos_impresion);
    ?>
    <style type="text/css">
        .botones {
            background: #ad0000;
            color: white;
            width: 100%;
            text-align: center;
            height: 40px;
            padding: 0;
            line-height: 37px;
        }
    </style>
    <?php add_thickbox(); ?>
    <button class="botones" id="generar-uea"><?php echo $texto_boton; ?></button>
    <?php
    $pedidoEnviado = get_post_meta($post->ID,'_pedido_enviado',true);
    if ($pedidoEnviado != "true"){
        ?>
        <button class="botones" id="impacta-pedido">Realizar solicitud de envio</button>
        <span id="notificacion_envio"></span>
        <?php
    } else {
        ?>
        <button class="botones" id="tracking-uea">Seguimiento</button>
        <?php
    }
    $cli_codigo = str_pad($order->get_id(),10, "0", STR_PAD_LEFT);
    $endpoint = $origen_datos["endpoint"];
    $numeracion = get_post_meta($order->get_id(),'_numeracion',true) ? get_post_meta($order->get_id(),'_numeracion',true) : "";
    $seguimiento = $endpoint."cespecifica/?shi_codigo=".str_pad($origen_datos['api_user'], 6, "0", STR_PAD_LEFT)."&cli_codigo=".$codigo_seguimiento;
    $etiqueta = $endpoint."impresionEtiqueta/?tipo=A4&shipper=".str_pad($origen_datos['api_user'], 6, "0", STR_PAD_LEFT)."&codSeguimiento=".prefix($cli_codigo,$numeracion);
    ?>
    <div id = "div-print" style = "display: none;">
        <object data='<?= $etiqueta ?>' type="application/pdf" width="100%" height="100%">
        </object>
    </div>
    <div id = "div-seguimiento" style = "display: none;">
        <iframe src="<?= $seguimiento ?>" width="100%" height="100%">
        </iframe>
    </div>
    <a href="#TB_inline?&width=800&height=600&inlineId=div-print" id="generar-uea-a" class="thickbox"></a>
    <a href="#TB_inline2?&width=800&height=600&inlineId=div-seguimiento" id="tracking-uea-a" class="thickbox"></a>
    <a href=""></a> 
    <?php
    echo '</div>';
}
add_action ('wp_ajax_print_urbano_ticket', 'print_urbano_ticket');
function print_urbano_ticket() {
    $fecha_impresion = new DateTime();
    update_post_meta( $_POST['id'], '_etiqueta_impresa', $fecha_impresion );
    echo $fecha_impresion->format('d/m/Y H:i:s');
    wp_die();
}
//funcion para asignar prefijo a los numeros de seguimiento
function prefix($tracking,$prex){
    $seguimiento = (int)$tracking;
    if ( $seguimiento > 0 ){
        if ( strlen($seguimiento) <= 9 ){
            $rest = str_pad($prex.$seguimiento, 10, "0", STR_PAD_LEFT);
            $rest = substr($rest, -10);
            return $rest;
        }
    }
    return $tracking;
}
function order_collect_data($order, $origen_datos)
{
    $data = array();
    $contrareembolso = ($origen_datos['contrareembolso']) ? $order->get_total() : 0;
    $declarado = $origen_datos['declarado'];
    if (isset($origen_datos["modo_envio"]) && $origen_datos["modo_envio"] == "ware"){
        $items = $order->get_items();
        $key = 0;
        foreach ($items as $item){
            $product = wc_get_product( $item['product_id'] );
            $data['data']['productos'][$key]['valorContrareembolso'] = $contrareembolso;
            $data['data']['productos'][$key]['valor'] = ($declarado * $order->get_subtotal()) / 100;
            $data['data']['productos'][$key]['cantidad'] = $item['qty'];
            $data['data']['productos'][$key]['sku'] = $product->get_sku();
            $data['data']['productos'][$key]['largo'] = $origen_datos['uea_lenth'];
            $data['data']['productos'][$key]['alto'] = $origen_datos['uea_height'];
            $data['data']['productos'][$key]['ancho'] = $origen_datos['uea_width'];
            $data['data']['productos'][$key]['peso'] = $origen_datos['uea_weightb'];
            $key+=1;
        }
    }else{
        $data['data']['productos'][0]['valorContrareembolso'] = $contrareembolso;
        $data['data']['productos'][0]['valor'] = ($declarado * $order->get_subtotal()) / 100;
        $data['data']['productos'][0]['cantidad'] = '1';
        $data['data']['productos'][0]['sku'] = '';
        $data['data']['productos'][0]['largo'] = $origen_datos['uea_lenth'];
        $data['data']['productos'][0]['alto'] = $origen_datos['uea_height'];
        $data['data']['productos'][0]['ancho'] = $origen_datos['uea_width'];
        $data['data']['productos'][0]['peso'] = $origen_datos['uea_weightb'];
    }
    $data['data']['productos'][0]['descripcionProducto'] = 'Pedido realizado a travez de WooCommerce';
    $data['data']['autentificacion']['shipper'] = $origen_datos['api_user'];
    $data['data']['autentificacion']['password'] = $origen_datos['api_password'];
    $data['data']['autentificacion']['endpoint'] = $origen_datos['endpoint'];
    $data['data']['porcentaje_iva'] = $origen_datos['porcentaje_iva'];
    $data['data']['envio_gratis'] = $origen_datos['envio_gratis'];
    $data['data']['ppc_active'] = $origen_datos['ppc_active'];
    $data['data']['destinatario']['tipoDocumento'] = '';
    $data['data']['destinatario']['numeroDocumento'] = '';
    $data['data']['destinatario']['nombre'] = $order->get_formatted_shipping_full_name();
    $data['data']['destinatario']['email'] = $order->get_billing_email();
    $data['data']['destinatario']['telefono'] = $order->get_billing_phone();
    $data['data']['destinatario']['celular'] = $order->get_billing_phone();
    $data['data']['autorizado'][0]['tipoDocumento'] = '';
    $data['data']['autorizado'][0]['numeroDocumento'] = '';
    $data['data']['autorizado'][0]['nombre'] = $order->get_formatted_shipping_full_name();
    $data['data']['autorizado'][0]['email'] = $order->get_billing_email();
    $data['data']['autorizado'][0]['telefono'] = $order->get_billing_phone();
    $data['data']['autorizado'][0]['celular'] = $order->get_billing_phone();
    //Verificar si está siendo enviado a un punto de retiro
    $code_id_ppc = NULL;
    $direccion = preg_replace('([^A-Za-z0-9 ])', '', $order->get_shipping_address_1()) . ' ' . preg_replace('([^A-Za-z0-9 ])', '', $order->get_shipping_address_2());
    $codigo_postal = $order->get_shipping_postcode();
    $localidad =  $order->get_shipping_city();
    $provincia = WC()->countries->get_states($order->get_shipping_country())[$order->get_shipping_state()];
    $obs_extra = '';
    if(isset($origen_datos['ppc']) && $origen_datos['ppc'] === true){
        $code_id_ppc = isset($origen_datos['ppc_datos']['id_ppc']) ? $origen_datos['ppc_datos']['id_ppc'] : 123;
        $direccion = $origen_datos['ppc_datos']['direccion'];
        $codigo_postal = $origen_datos['ppc_datos']['codigo_postal'];
        $localidad = $origen_datos['ppc_datos']['prov_codigo'];
        $provincia = $origen_datos['ppc_datos']['provincia'];

        if(isset($origen_datos['ppc_datos']['prov_codigo'])){
            $obs_extra = "Punto de retiro ".  $origen_datos['ppc_datos']['prov_codigo'];
        }
    }
    $numeracion = substr($origen_datos['numeracion'], 0, 2);
    $seguimiento = $order->get_id();
    $data['data']['domicilio']['direccion'] = $direccion;
    $data['data']['domicilio']['altura'] = "";
    $data['data']['domicilio']['piso'] = "";
    $data['data']['domicilio']['departamento'] = "";
    $data['data']['domicilio']['codigoPostal'] = $codigo_postal;
    $data['data']['domicilio']['localidad'] = $localidad;
    $data['data']['domicilio']['provincia'] = $provincia;
    $data['data']['domicilio']['latitud'] = "";
    $data['data']['domicilio']['longitud'] = "";
    $data['data']['domicilio']['telefono'] = $order->get_billing_phone();
    $data['data']['domicilioAlternativo']['direccion'] = $direccion;
    $data['data']['domicilioAlternativo']['altura'] = "";
    $data['data']['domicilioAlternativo']['piso'] = "";
    $data['data']['domicilioAlternativo']['departamento'] = "";
    $data['data']['domicilioAlternativo']['codigoPostal'] = $codigo_postal;
    $data['data']['domicilioAlternativo']['localidad'] = $localidad;
    $data['data']['domicilioAlternativo']['provincia'] = $provincia;
    $data['data']['domicilioAlternativo']['latitud'] = "";
    $data['data']['domicilioAlternativo']['longitud'] = "";
    $data['data']['domicilioAlternativo']['telefono'] = $order->get_billing_phone();
    $data['data']['datoNumerico'] = prefix($seguimiento,$numeracion);
    $data['data']['codigoSeguimiento'] = prefix($seguimiento,$numeracion);
    $data['data']['modeloSms'] = "";
    $data['data']['modeloEmail'] = "";
    if ($order->get_payment_method() == 'cod') {
        $data['data']['servicio'] = "B";
    } else {
        $data['data']['servicio'] = "E";
    }
    if(!is_null($code_id_ppc)){
        $data['data']['servicio'] = "F";

        if($contrareembolso > 0)
            $data['data']['servicio'] = "G";
    }
    $data['data']['marcaDeAgua'] = "";
    $data['data']['remito'] = "";
    $data['data']['observaciones'] = array(
        preg_replace('([^A-Za-z0-9 ])', '', $order->get_customer_note()),
        $obs_extra
    );
    return $data;
}
/**
 * Añade el campo bulto a la página de order list de WooCommerce
 */
add_action('load-edit.php', 'wco_load', 20);
function wco_load() {
    $screen = get_current_screen();
    if (!isset($screen->post_type) || 'shop_order' != $screen->post_type) {
        return;
    }
    //* Agregar la columna personalizada a la tabla de lista existente
    add_filter("manage_{$screen->id}_columns", 'wco_add_columns');
    //* Visualización de contenido en la columna personalizada
    add_action( "manage_{$screen->post_type}_posts_custom_column", 'wco_column_cb_data', 10, 2 );
}
// Funcion que nos permite visualizar el input
function wco_column_cb_data( $colname, $cptid ) {
    // Traemos el Origen datos
    $order = wc_get_order( $cptid );
    $cli_codigo = str_pad($order->get_id(),10, "0", STR_PAD_LEFT);
    $origen_datos = get_post_meta($cptid,'_origen_datos_uea',true);
    if ($origen_datos==false)
        $origen_datos = get_post_meta($cptid,'_origen_datos',true);

    $origen_datos = json_decode($origen_datos,JSON_FORCE_OBJECT)[0];
    $endpoint = $origen_datos["endpoint"];
    // Preguntamos si pertenece la columna a Bultos y si auto impacto es igual a false
    $bultosEnviado = get_post_meta($cptid,'_bultos',true);
    $pedidoEnviado = get_post_meta($cptid,'_pedido_enviado',true);
    $numeracion = get_post_meta($cptid,'_numeracion',true) ? get_post_meta($cptid,'_numeracion',true) : "";
    $numeracion = substr($numeracion, 0,1);
    $bultos = $bultosEnviado? $bultosEnviado : 1;
    if (isset($origen_datos["modo_envio"]) && $origen_datos["modo_envio"] == "ware")
        $modo_envio = true;
    else
        $modo_envio = false;
    
    // Deshabilitar input en caso que se haya enviado o no pertenece
    if (!$endpoint || $pedidoEnviado || $modo_envio){
         $disable = "readonly";
    }else{
        $disable = null;
    }
    $type = $endpoint ? "type=number" : null;
    $codigo_seguimiento = prefix($cli_codigo,$numeracion);
    $seguimiento = $endpoint."cespecifica/?shi_codigo=".str_pad($origen_datos['api_user'], 6, "0", STR_PAD_LEFT)."&cli_codigo=".$codigo_seguimiento;
    $etiqueta = $endpoint."impresionEtiqueta/?tipo=A4&shipper=".str_pad($origen_datos['api_user'], 6, "0", STR_PAD_LEFT)."&codSeguimiento=".$codigo_seguimiento;
    // Creamos las columnas los input y urbano
    if ($colname == 'bultos' && $endpoint && !$modo_envio)
        echo "<a href='javascript:void(0)'><input name='bultos[$cptid]' style='width:65px;text-align:center' $disable href='#' min='1' value='$bultos' $type /></a>";
    if($colname == 'urbano'){
        if ($pedidoEnviado){
            echo "<a href='".$seguimiento."' target=_blank><h4 class='dashicons-before dashicons-location'>".$codigo_seguimiento."</h4></a>";
        }
    }
    if ($colname == 'etiqueta' && $pedidoEnviado)
        echo "<a href='".$etiqueta."' target=_blank><h4 class='dashicons-before dashicons-text-page'>Imprimir</h4></a>";
    ?>
    <script type="text/javascript">
        var $ = jQuery.noConflict();
        jQuery('body').on('click', '#generar-uea',function(e){
            e.preventDefault();
            $('#generar-uea-a').click();
            let data = {
                'action': 'print_urbano_ticket',
                'id':'<? echo $post->ID ?>'
            };
            jQuery.post(ajaxurl, data, function(response) {
                $('#info_print').html('Etiqueta impresa el ' + response);
            });
        });
        jQuery('body').on('click', '#tracking-uea',function(e){
            e.preventDefault();
            $('#tracking-uea-a').click();
        });
    </script>
    <?php
}
// Funcion para agregar columnas
function wco_add_columns( $columns ) {
    $actions = $columns['order_actions'];
    $order_total = $columns['order_total'];
    $order_date = $columns['order_date'];
    // Borramos la columnas temporalmente
    unset($columns['order_date']);
    unset($columns['order_total']);
    unset($columns['order_actions']);
    // Añadimos las columnas
    $columns["bultos"] = __( "Bultos", "themeprefix");
    $columns["urbano"] = __( "Urbano", "themeprefix");
    $columns["etiqueta"] = __( "Etiqueta", "themeprefix");
    $columns['order_date'] = $order_date;
    $columns['order_total'] = $order_total;
    $columns['order_actions'] = $actions;
    return $columns;
}
//Ubicacion del listado a continuacion del checkout de shipping
add_action( 'wp_footer', 'only_urbano');
function only_urbano(){ 
    if ( is_checkout() ) { ?>
        <script type="text/javascript">
        jQuery(document).ready(function () {  
            jQuery('#pick_up_locations').insertAfter( jQuery( '.woocommerce-checkout-review-order-table' ) );  
            jQuery('#pick_up_locations_field').insertAfter( jQuery( '.woocommerce-checkout-review-order-table' ) );
            jQuery('.woocommerce-pickup-fields').insertAfter( jQuery( '.woocommerce-checkout-review-order-table' ) );    
        });
        </script>
 <?php }
}
#Impactar orden en urbano
function curl_call($data){
    $endpoint = $data['data']['autentificacion']['endpoint'];
    $params = json_encode($data['data']);
    $ch = curl_init($endpoint.'cargaCliente/');
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
    $uea_response = curl_exec ($ch);
    $uea_response = json_decode($uea_response,true);
    curl_close($ch);
    return $uea_response;
}
// Añadir la columna personalizada
add_filter('woocommerce_admin_order_columns', 'add_custom_column', 10, 3);
// Rellena la columna con el contenido personalizado (en este caso, un botón)
function mostrar_contenido_columna_personalizada($column) {
    global $post;
    $order_id = get_the_ID();
    $pedidoEnviado = get_post_meta($order_id, '_pedido_enviado', true);

    if ($column == 'urbano' && !$pedidoEnviado) {
        echo '<button href="#" class="boton-notificacion" data-order-id="' . $order_id . '">Enviar</button>';
    }
}
add_action('manage_shop_order_posts_custom_column', 'mostrar_contenido_columna_personalizada');
// Agrega el script JavaScript para manejar la solicitud AJAX
function agregar_script_notificacion() {
    if (isset($_GET['post_type']) && $_GET['post_type'] == 'shop_order') {
        wp_enqueue_script('jquery');
        echo '
            <script>
                jQuery(document).ready(function($) {
                    $(".boton-notificacion").on("click", function(event) {
                        event.preventDefault();
                        var $button = $(this);
                        var order_id = $button.data("order-id");
                        var bultos = $("input[name=\"bultos[" + order_id + "]\"]").val(); // Obtén el valor de bultos                   
                        if (!$button.data("click-processed")) {
                            $button.data("click-processed", true); // Marcar el botón como procesado para evitar clics adicionales
                            $.ajax({
                                url: ajaxurl,
                                type: "POST",
                                data: {
                                    action: "obtener_mensaje_personalizado",
                                    order_id: order_id,
                                    bultos: bultos // Envía el valor de bultos  
                                },
                                success: function(mensaje) {
                                    $(".wrap h1").after(\'<div class="notice notice-success is-dismissible"><p>\' + mensaje + \'</p></div>\');
                                    // Recargar la página después de 2 segundos
                                    setTimeout(function() {
                                        location.reload();
                                    }, 2000);
                                }
                            });
                        }
                    });
                });
            </script>
        ';
    }
}
add_action('admin_notices', 'agregar_script_notificacion');
// Agrega la función que responderá a la solicitud AJAX
function obtener_mensaje_personalizado_ajax() {
    $order_id = $_POST['order_id'];
    $bultos = $_POST['bultos'] ?? [];
    $mensaje = obtener_mensaje_personalizado($order_id,$bultos);
    echo $mensaje;
    wp_die(); // Termina la ejecución de WordPress
}
add_action('wp_ajax_obtener_mensaje_personalizado', 'obtener_mensaje_personalizado_ajax');
add_action('wp_ajax_nopriv_obtener_mensaje_personalizado', 'obtener_mensaje_personalizado_ajax');
// Define la función obtener_mensaje_personalizado
function obtener_mensaje_personalizado($order_id,$bultos) {
    // Implementa la lógica para obtener el mensaje personalizado
    $bultos[$order_id] = $bultos;
    $impacta = impacta_pedido($order_id, true, $bultos[$order_id]);
    return $impacta;
}
#Funcion para impactar el pedido en urbano
function impacta_pedido($order_id_bulk_actions = false, $button = false, $bultos_button = []){
    if($order_id_bulk_actions){
        $order_id = $order_id_bulk_actions;
    }else{
        $order_id =  $_POST['id'];
    }
    $order = wc_get_order( $order_id  );
    $origen_datos = get_post_meta($order_id ,'_origen_datos_uea',true);
    if ($origen_datos==false)
        $origen_datos = get_post_meta($order_id,'_origen_datos',true);

    $origen_datos = json_decode($origen_datos,true)[0];
    #Recibe el parametro bulto del formulario de envio
    $bultos[] = $_GET['bultos'] ?? $bultos_button;
    $data = order_collect_data($order, $origen_datos);
    if ( $origen_datos["modo_envio"] == "cross" || !$origen_datos["modo_envio"] || !isset($origen_datos["modo_envio"]) ){
        #Recorremos el array segun la orden
        foreach ($bultos as $bulto){
            # En caso de estar vacio es 1 de lo contrario es el valor indicado
            if ((int)$bulto[$order_id]>0){
                $cantidad = $bulto[$order_id];
            }else{
                $cantidad = $bultos_button ?? 1;
            }
        }
        #Recorremos el array para asignarle la cantidad a la orden
        foreach ($data as $key => $value){
            $value["productos"][0]["cantidad"]=$cantidad;
        }
    }else{
        foreach ($data as $key => $value){
            $data['data']['productos'][0]['descripcionProducto'] = 'Pedido con id '.$order_id.' realizado a travez de WooCommerce, ware';
        }
    }
    #Asignamos al array asociativo en el array data
    $orden = array ( "data"  => $value  );
    $pedidoEnviado = get_post_meta($order_id,'_pedido_enviado',true);
    $prefix = $origen_datos["numeracion"];
    if($pedidoEnviado != "true"){
        $uea_response = curl_call($orden);
        if ($uea_response['codError'] == 0){
            update_post_meta( $order_id , '_bultos', $cantidad);
            update_post_meta( $order_id , '_pedido_enviado', "true" );
            if ($prefix!= null)
                update_post_meta( $order_id , '_numeracion', $prefix );
       
            if($order_id_bulk_actions && !$button){
                return true;
            }else
                return 'El pedido con id '.$order_id.' se envio exitosamente a Urbano!';
                     
        } else {
            if($order_id_bulk_actions && !$button){
                return false;
            }else{
                return 'El pedido con id '.$order_id.' no pudo ser impactado '.
                'codError: '.$uea_response['codError'].' </br>'.
                'descError: '.$uea_response['descError'].' </br>'.
                'Verifique la documentación</br>'.
                'Si el problema persiste comuníquese con urbano';                
            }
        }
    }else{
        if($order_id_bulk_actions && !$button){
            return false;
        }else{
            return "Atención: ¡Este pedido con id $order_id ya se encuentra registrado en Urbano!";
        }
    }    
    return 'El pedido con id '.$order_id.' no pudo ser impactado';
}
add_action( 'woocommerce_checkout_payment_processed', 'checkout_order_payment_uea' );
function checkout_order_payment_uea( $order_id ){
    $order = wc_get_order( $order_id );
    $origen_datos = get_post_meta($order_id,'_origen_datos_uea',true);
    if ($origen_datos==false)
        $origen_datos = get_post_meta($order_id,'_origen_datos',true);

    $origen_datos = json_decode($origen_datos,true)[0];
    update_post_meta( $order_id, '_chosen_shipping', 'uea_ueforwoocom');
    update_post_meta( $order_id, '_estado', $order->get_status() );
    if ($origen_datos["auto_impacto" ]== "pagado"){
        impacta_pedido($order_id,true);
    }
}
add_action( 'woocommerce_thankyou', 'checkout_order_processed_uea', 10, 1 );
function checkout_order_processed_uea( $order_id ){
    session_start();
    $order = wc_get_order( $order_id );
    $origen_datos = get_post_meta($order_id,'_origen_datos_uea',true);
    if ($origen_datos==false)
        $origen_datos = get_post_meta($order_id,'_origen_datos',true);

    $origen_datos = json_decode($origen_datos,true)[0];
    update_post_meta( $order_id, '_origen_datos_uea', $_SESSION['origen_datos_uea'] );
    update_post_meta( $order_id, '_chosen_shipping', 'uea_ueforwoocom');
    update_post_meta( $order_id, '_estado', $order->get_status() );
    if ($origen_datos["auto_impacto"] == "si"){
        impacta_pedido($order_id,true);
    }
}
// agregar acción por lote en vista de pedidos woocommerce
add_filter( 'bulk_actions-edit-shop_order', 'proceso_lotes_bulk_actions' );
function proceso_lotes_bulk_actions( $bulk_actions ) {
    $bulk_actions['send_orders'] = 'Enviar pedidos a Urbano Express Argentina';
    $bulk_actions['print_formato'] = 'Generar etiquetas por lote';
    return $bulk_actions;
}
// Proceso del envío por lote para las etiquetas
add_filter( 'handle_bulk_actions-edit-shop_order', 'proceso_lotes_bulk_action_edit_shop_order', 10, 3 );
function proceso_lotes_bulk_action_edit_shop_order( $redirect_to, $action, $order_ids ) {    
    if ( $action === 'print_formato' ){
        // inicializamos
        #Array de bultos
        $bultos[] = $_GET['bultos'];
        #Recorremos el array segun la orden
        $processed_ids = array(); 
        $failed_ids = array(); 
        $success_processes_count = 0;
        $failed_processes_count = 0;
        $datos_impresion = array();
        foreach ( $order_ids as $order_id ) {
            $order = wc_get_order( $order_id  );
            $origen_datos = get_post_meta($order_id ,'_origen_datos_uea',true);
            if ($origen_datos==false)
                 $origen_datos = get_post_meta($order_id,'_origen_datos',true);

            $origen_datos = json_decode($origen_datos,true)[0];
            $bultosEnviado = get_post_meta($order_id,'_pedido_enviado',true);

            $numeracion = substr($origen_datos['numeracion'], 0, 2);
            $seguimiento = $order->get_id();
            if ($bultosEnviado){
                #Recorremos el array de bultos generado por el formulario
                foreach ($bultos as $bulto){
                    $cantidad[$order_id] = $bulto[$order_id];
                }
                $datos = [
                    'cli_codigo' => prefix($seguimiento,$numeracion),
                    'shipper' => $origen_datos['api_user'],
                    'bultos' => $cantidad[$order_id]?$cantidad[$order_id]:1,
                ];
                array_push($datos_impresion, $datos);//para agregar nuevo elemento al array  
                $success_processes_count++;
                $processed_ids[] = prefix($seguimiento,$numeracion);
            }else{
                $failed_ids[] = $order_id;
                $failed_processes_count++;
            }
        }
        // agregamos los parámetros a la url devuelta
        $redirect_to = add_query_arg( array(
            'print_formato' => '1',
            'ordenes2' => $datos_impresion,
            'success_processes_count2' => $success_processes_count,
            'failed_processes_count2' => $failed_processes_count,
            'processed_ids2' => implode( ',', $processed_ids ),
            'failed_ids2' => implode( ',', $failed_ids ),
        ));
    }
    if ( $action === 'send_orders' ){
        // inicializamos
        $processed_ids = array(); 
        $failed_ids = array(); 
        $success_processes_count = 0;
        $failed_processes_count = 0;
        foreach ( $order_ids as $order_id ) {
            //enviamos el id_order para impactoPedido, y guardamos la respuesta
            if(impacta_pedido($order_id)){
                $success_processes_count++;
                $processed_ids[] = $order_id;
            }else{
                $failed_ids[] = $order_id;
                $failed_processes_count++;
            }               
        }
        // agregamos los parámetros a la url devuelta
        $redirect_to = add_query_arg( array(
            'send_orders' => '0',
            'success_processes_count' => $success_processes_count,
            'failed_processes_count' => $failed_processes_count,
            'processed_ids' => implode( ',', $processed_ids ),
            'failed_ids' => implode( ',', $failed_ids ),
        ));
    }
    return $redirect_to;
}
// Mostrar resultados luego de el envío por lote
add_action( 'admin_notices', 'proceso_lotes_bulk_action_admin_notice' );
function proceso_lotes_bulk_action_admin_notice() {
    global $pagenow;
    if ( 'edit.php' === $pagenow 
    && isset($_GET['post_type']) 
    && 'shop_order' === $_GET['post_type']
    ) {
        if (isset($_GET['send_orders'])){
            $success_processes_count = intval( $_REQUEST['success_processes_count'] );
            $failed_processes_count = intval( $_REQUEST['failed_processes_count'] );
            #mostramos el mensaje de pedidos enviados correctamente.
            if( $success_processes_count > 0){
                $ordenes_procesadas = array();
                $ordenes_id = array();
                $orders = explode( ',' , $_GET['processed_ids']);
                foreach($orders as $order){
                    $ordenes_procesadas[] = "#". $order;
                }
                printf( '<div class="notice notice-success fade is-dismissible"><p>' .
                    _n( '%s Pedido registrado en Urbano satisfactoriamente. ID Pedido ' . implode(', ' , $ordenes_procesadas),
                    '%s pedidos fueron registrados en Urbano satisfactoriamente. IDs de los Pedidos ' . implode(', ' , $ordenes_procesadas),
                    $success_processes_count,
                    'woocommerce'
                ) . '</p></div>', $success_processes_count );
            }
            #si hay procesos fallidos mostramos el mensaje de error
            if( $failed_processes_count > 0){
                $failed_orders = explode( ',' , $_GET['failed_ids']);
                $ordenes_no_procesadas = array();
                foreach($failed_orders as $order){
                    $ordenes_no_procesadas[] = "#". $order;
                }
                printf( '<div class="notice notice-error fade is-dismissible"><p>' .
                _n( '%s pedido no pudo ser registrado en Urbano. ID de Pedido ' . implode(', ' , $ordenes_no_procesadas) ,
                '%s pedidos no pudieron ser registrados en Urbano. IDs de los Pedidos ' . implode(', ' , $ordenes_no_procesadas),
                $failed_processes_count,
                'woocommerce'
                ) . '</p></div>', $failed_processes_count );
            }
        }
        if (isset($_GET['print_formato'])){
            $ordenes = $_GET['ordenes2'];
            $success_processes_count2 = intval( $_REQUEST['success_processes_count2'] );
            $failed_processes_count2 = intval( $_REQUEST['failed_processes_count2'] );
            #verifica si hay procesos por lote
            if( $success_processes_count2 > 0){
                $ordenes_procesadas = array();
                $ordenes_id = null;
                $orders = explode( ',' , $_GET['processed_ids2']);
                #si hay procesos fallidos mostramos el mensaje de error
                foreach($orders as $order){
                    $ordenes_procesadas[] = "#". $order;
                    
                    $ordenes_id.= "&id[]=".$order;

                }
                $ordenes_id = preg_replace('/[^A-Za-z0-9 & =\[\]]/', '', $ordenes_id);
                #mostramos el boton de impresion.
                 printf( '<div class=notice><p><buton style="position:relative;top:2px;" onclick=porFormato() class=page-title-action target=_blank>IMPRIMIR</buton>&nbsp;<a href="javascript:void(0)"><select id="formato" name="formato" data-toggle="tooltip" data-placement="top" title="Seleccione la etiqueta que Urbano imprimirá" class= data-etiqueta>
                      <option value="A4">A4</option>
                      <option value="Z10X10">Z10X10</option>
                      <option value="Z10X15">Z10X15</option>
                      <option value="Z10X6">Z10X6</option>
                      <option value="zpl">zpl</option>
                    </select></a><br/>'.
                    _n( ' %s etiqueta por generar, seleccione el formato de impresión, ID de etiqueta ' . implode(', ' , $ordenes_procesadas),'%s etiquetas por generar, seleccione el formato de impresión, ID de etiquetas ' . implode(', ' , $ordenes_procesadas),
                    ' %s Etiquetas por generar, seleccione el formato de impresión. ' ,
                    $success_processes_count2,
                    'woocommerce'
                ) . '', $success_processes_count2 );
                #Generamos la funcion para el proceso para la url de impresion
                $shipper= $ordenes[0]['shipper'];


                echo "<script>
                        function porFormato(){
                            var lote,formato;
                            formato = document.getElementById('formato');
                            var selected = formato.options[formato.selectedIndex].text;
                            lote = encodeURI('https://integrate.urbano.com.ar/tienda_nube/etiqueta?locale=es&shipper=$shipper$ordenes_id');
                            window.open(lote);
                        }
                        porFormato();
                      </script>
                    </div>";
                    #si hay procesos fallidos mostramos el mensaje de error
            }
            if( $failed_processes_count2 > 0){
                $failed_orders = explode( ',' , $_GET['failed_ids2']);
                $ordenes_no_procesadas = array();
                foreach($failed_orders as $order){
                    $ordenes_no_procesadas[] = "#". $order;
                }
                printf( '<div class="notice notice-error fade is-dismissible"><p>' .
                _n( '%s etiqueta no pudo ser generada al no ser impactada previamente, ID de etiqueta ' . implode(', ' , $ordenes_no_procesadas) ,
                '%s etiquetas no pudieron ser generadas al no ser impactadas previamente, ID de etiquetas ' . implode(', ' , $ordenes_no_procesadas),
                $failed_processes_count2,
                'woocommerce'
                ) . '</p></div>', $failed_processes_count2 );
            }
        }
    }
}
// Métodos para los puntos pickup
add_action( 'woocommerce_before_checkout_form', 'bbloomer_print_cart_weight' );
add_action( 'woocommerce_before_cart', 'bbloomer_print_cart_weight' );
#Calcular peso total de productos
function bbloomer_print_cart_weight() {
   session_start(); 
   $_SESSION['peso_productos_ppc'] = WC()->cart->get_cart_contents_weight();
}
add_filter('woocommerce_checkout_fields', 'bbloomer_display_pickup_locations');
//funcion para busqueda de endopint de pickup
function bbloomer_display_pickup_locations($fields)
{
    session_start();
    global $wp_session,$wpdb;
    $resultados= $wpdb->get_results( "SELECT option_value FROM ".$wpdb->prefix."options WHERE option_name like '%woocommerce_uea_ueforwoocom%' LIMIT 1" );
    $origen_datos = unserialize($resultados[0]->option_value);

    if ($origen_datos["ppc_active"]!="yes"){
        $fields['billing']['nopickup'] = array(
        );
        return $fields;
    }
    $peso_ppc = isset($_SESSION['peso_productos_ppc']) && is_numeric($_SESSION['peso_productos_']) && $_SESSION['peso_productos_']>0 ? (double)$_SESSION['peso_productos_ppc'] : 1;
    $params = '{
        "ubicacion": {
            "va_prov_codigo": "%",
            "va_con_llc": 1
        },
        "pieza": {
            "peso": '.$peso_ppc.',
            "alto": 0,
            "largo": 0,
            "ancho": 0
        },
        "autentificacion": {
            "shipper": "'.$origen_datos['api_user'].'",
            "password": "'.$origen_datos['api_password'].'"
        },
        "elockers" : 0
    }';
    $url = $origen_datos['endpoint'] . 'puntosDeRetiroSucursales/';
    $ch = curl_init($url);
    curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_HTTPHEADER, array('Content-Type:application/json'));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
    $uea_response = curl_exec($ch);
    $sucursales = json_decode($uea_response, true);
    curl_close($ch);
    if(isset($sucursales[0]['data'])){
        $sucursales = $sucursales[0]['data'];
    }
    else{
        $sucursales = false;
    }
   $arrayRate = array();
   if ($origen_datos["listado_ppc"]=="pickup" || !isset($origen_datos["listado_ppc"]) )
        $seleccion = "G";
   elseif ($origen_datos["listado_ppc"]=="sucursales")
        $seleccion = "S";
   else
        $seleccion = "T";
    
    $arrayRate[] ="Sin sucursal";
    if($sucursales){
        $_SESSION['sucursales_ppc'] = $sucursales;
             
        for ($k=0; $k < count($sucursales); $k++) {
            $cod = substr($sucursales[$k]['prov_codigo'], 0, 1);

            if ($sucursales[$k]['codigoPostal'] && ($cod==$seleccion || $seleccion=="T")){
                $provincia = $sucursales[$k]['provincia'] ? $sucursales[$k]['provincia'] : $sucursales[$k]['municipalidad'];
                $direccion = $provincia . ' - CP: ' . $sucursales[$k]['codigoPostal'] ." ". $sucursales[$k]['direccion'] ;
                $arrayRate[] = $direccion." (".$sucursales[$k]['prov_codigo'].")";
            }
        }
    }

    $fields['billing']['pick_up_locations'] = array(
        'type' => 'select',
        'options' => $arrayRate,
        'label' => __('Puntos gire', 'woocommerce'),
        'class' => array('form-row-wide'),
        'clear' => true,
    );
    
    return $fields;

}
//gancho de la funcion para el endpoint de pickup
add_action('woocommerce_after_checkout_form', 'bbloomer_conditionally_hide_show_pickup', 5);
//script para ajax de pickup
function bbloomer_conditionally_hide_show_pickup()
{
    ?>
   <script type="text/javascript">
            updateTarifaAjax();
            jQuery(document).ready(function(){
                jQuery('select#pick_up_locations').on('change', function(){
                    var selectElement = document.getElementById("pick_up_locations");
                    var selectedIndex = selectElement.selectedIndex;
                    var address = selectElement.options[selectedIndex].text;
                    var value = jQuery(this).val();
                    var punto_r = false;                   
                    if(value != 0){
                        punto_r = true;
                        jQuery("#ship-to-different-address-checkbox").prop("disabled", true);
                    }else{
                        jQuery("#ship-to-different-address-checkbox").prop("disabled", false);
                    }
                    jQuery(this).toggleClass('clicked');
                    updateTarifaAjax(value,punto_r,address);
                });                
            });
            function updateTarifaAjax(value = 0, punto_r = false, address = null){
                jQuery.ajax({
                type:'POST',
                data:{
                    action:'my_unique_action',
                    id_ppc: value,
                    punto_r : punto_r,
                    address_ppc : address
                },
                url: '<?= admin_url('admin-ajax.php') ?>',
                    success: function(value) {
                        jQuery(this).html(value);
                        jQuery('body').trigger('update_checkout');
                    }
                });
            }
   </script>
   <?php
}
//para ajax de usuarios no registrados
add_action('wp_ajax_nopriv_my_unique_action','so_wp_ajax_function', 10, 2 );
//para ajax de usuarios registrados
add_action('wp_ajax_my_unique_action','so_wp_ajax_function', 10, 2 );
//funcion como controlador para calcular el shipping desde pickup
function so_wp_ajax_function(){
    session_start();
    $_SESSION["id_ppc"]= $_POST['id_ppc'];
    $_SESSION["punto_r"]= $_POST['punto_r'];
    $_SESSION["address_ppc"]= $_POST['address_ppc'];
    unset(WC()->session->$shipping_session);
    WC()->cart->calculate_shipping();    
    wp_die();
}
add_filter('woocommerce_checkout_update_order_review', 'clear_wc_shipping_rates_cache');
function clear_wc_shipping_rates_cache(){
    $packages = WC()->cart->get_shipping_packages();
    foreach ($packages as $key => $value) {
        $shipping_session = "shipping_for_package_$key";
        unset(WC()->session->$shipping_session);
    }
}

// Hook para inicializar las tareas programadas al activar el plugin
function inicializar_verificacion_actualizaciones() {
    // Verifica si el evento ya está programado
    if (!wp_next_scheduled('verificar_actualizacion_plugin_evento')) {
        // Programa el evento para que se ejecute diariamente
        wp_schedule_event(time(), 'daily', 'verificar_actualizacion_plugin_evento');
    }
}

// Añade la función de inicialización al hook 'admin_init' para que se ejecute en el panel de administración
add_action('admin_init', 'inicializar_verificacion_actualizaciones');

// Hook para ejecutar la función de verificación de actualizaciones cuando el evento se dispara
add_action('verificar_actualizacion_plugin_evento', 'verificar_actualizacion_plugin');

// Verifica la existencia de un nuevo plugin
function verificar_actualizacion_plugin() {

  /*  add_action('admin_notices', function() {
        echo '<div class="notice notice-warning">
                 <p>se ejecuto el hook. <a href="">Descárgala aquí</a>.</p>
             </div>';
    }); */
    
    $version_info = wp_remote_get('https://dev.integrate.urbano.com.ar/version.json');
    if (is_wp_error($version_info)) {
        return;
    }

    $version_data = json_decode(wp_remote_retrieve_body($version_info));
    $version_actual = '2.0.2.5'; // Tu versión actual

    if (version_compare($version_actual, $version_data->version, '<')) {
        // Notificar al usuario
        add_action('admin_notices', function() use ($version_data) {
            echo '<div class="notice notice-warning">
                     <p>Hay una nueva versión del plugin de <b>Urbano Shipping for WooCommerce</b> disponible. <a href="' . esc_url($version_data->download_url) . '">Descárgala aquí</a>.</p>
                 </div>';
        });
    }
}
add_action('admin_init', 'verificar_actualizacion_plugin');

// Función para limpiar las tareas programadas al desactivar el plugin
function desactivar_plugin() {
    wp_clear_scheduled_hook('verificar_actualizacion_plugin_evento');
}
register_deactivation_hook(__FILE__, 'desactivar_plugin');

?>
