<?php

use PrestaShop\PrestaShop\Core\Module\WidgetInterface;

if (!defined('_PS_VERSION_')) {
    exit;
}

class EnvioUrbano extends CarrierModule implements WidgetInterface
{

    public $id_carrier;
    private $_html = '';
    private $_postErrors = array();

    public function __construct()
    {
        $this->bootstrap = true;
        $this->name = 'enviourbano';
        $this->tab = 'shipping_logistics';
        $this->version = '1.2.1.2';
        $this->author = 'Urbano Express S. A.';
        $this->ps_versions_compliancy = array('min' => '1.7.0.0', 'max' => _PS_VERSION_);
        parent::__construct();
        $this->displayName = $this->trans('Guia Envio - Urbano Express Argentina.', array(), 'Modules.EnvioUrbano.Admin');
        $this->description = $this->trans('Calcula el costo del envio y genera la guía directamente en Urbano Express.', array(), 'Modules.EnvioUrbano.Admin');
    }

    public function install()
    {
        try {
            $carrierConfig = array(
                0 => array('name' => 'Urbano',
                    'id_tax_rules_group' => 0,
                    'active' => true,
                    'deleted' => 0,
                    'shipping_handling' => false,
                    'range_behavior' => 0,
                    'delay' => array(Language::getIsoById(Configuration::get('PS_LANG_DEFAULT')) => 'Urbano Express Argentina'),
                    'id_zone' => 1,
                    'is_module' => true,
                    'shipping_external' => true,
                    'external_module_name' => $this->name,
                    'need_range' => true,
                ),
            );
            $id_carrier1 = $this->installExternalCarrier($carrierConfig[0]);
            parent::install();
            Configuration::updateValue('ID_CARRIER_URBANO', (int) $id_carrier1);            
            Configuration::updateValue('CARRIER_URBANO_REFERENCIA', (int) $id_carrier1);
            Configuration::updateValue('FLAG_URBANO', true);
            $this->registerHook('updateCarrier');
            $this->registerHook('DisplayBackOfficeHeader');
            $this->registerHook('actionCarrierUpdate');
            $parent_tab = new Tab();
            $parent_tab->name[$this->context->language->id] = $this->trans('Urbano', array(), 'AdminUrbanoTab');
            $parent_tab->class_name = 'AdminUrbanoTab';
            $parent_tab->id_parent = 0; // Home tab
            $parent_tab->module = $this->name;
            $parent_tab->add();
            $tab = new Tab();
            $tab->name[$this->context->language->id] = $this->trans('Gestionar envíos pendientes', array(), 'AdminGestionEnvio');
            $tab->class_name = 'AdminGestionEnvio';
            $tab->id_parent = $parent_tab->id;
            $tab->module = $this->name;
            $tab->icon = 'list';
            $tab->add();

            $tab = new Tab();
            $tab->name[$this->context->language->id] = $this->trans('Pedidos enviados', array(), 'AdminGestionPedidosEnviados');
            $tab->class_name = 'AdminGestionPedidosEnviados';
            $tab->id_parent = $parent_tab->id;
            $tab->module = $this->name;
            $tab->icon = 'done';
            $tab->add();


            // Craar tabla para urbano express, gestión de pedidos
            
            Db::getInstance()->execute('CREATE TABLE IF NOT EXISTS `' . _DB_PREFIX_ . 'uea_gestion_envio` (
                `id_gestion_envio` int(11) unsigned NOT NULL AUTO_INCREMENT,
                `id_order` INT( 11 ) UNSIGNED NOT NULL,
                `fecha_envio` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
                PRIMARY KEY (`id_gestion_envio`),
                UNIQUE  `ID_ORDER_UNIC` (  `id_order` )
                ) ENGINE=' . _MYSQL_ENGINE_ . ' DEFAULT CHARSET=utf8;'); 


        } catch (PrestaShopDatabaseException $e) {
            return false;
        } catch (PrestaShopException $e) {
            return false;
        }
        return true;
    }

    public function hookActionCarrierUpdate($params)
    {
        if ($params['carrier']->id_reference == Configuration::get('CARRIER_URBANO_REFERENCIA')) {
            Configuration::updateValue('ID_CARRIER_URBANO', $params['carrier']->id);
        }
    }

    public function uninstall()
    {
        try {
            parent::uninstall();
            $this->unregisterHook('updateCarrier');
            $this->unregisterHook('DisplayBackOfficeHeader');
            $this->unregisterHook('actionCarrierUpdate');
            $Carrier1 = new Carrier((int) (Configuration::get('ID_CARRIER_URBANO')));
            // Uninstall Tabs
            $tabTrack = new Tab((int) Tab::getIdFromClassName('AdminUrbanoTab'));
            $tabTrack->delete();
            $tabMain = new Tab((int) Tab::getIdFromClassName('AdminTrackingUrbano'));
            $tabMain->delete();
            $tabGestoinEnvio = new Tab((int) Tab::getIdFromClassName('AdminGestionEnvio'));
            $tabGestoinEnvio->delete();
            $Carrier1->deleted = 1;
            $Carrier1->active = 0;
            $Carrier1->update();
            //Colocar valores default de las variables en BD
            Configuration::updateValue('ID_SHIPPER_URBANO', '1258');
            Configuration::updateValue('KEY_SHIPPER_URBANO', 'XX');
            Configuration::updateValue('ENDPOINT_SERVICIO_URBANO', 'urbano.com.ar');
            Configuration::updateValue('COEFICIENTE_AFORO_URBANO', '4000');
            Configuration::updateValue('IMPORTE_ENVIO_URBANO', '0');

        } catch (PrestaShopDatabaseException $e) {
            return false;
        } catch (PrestaShopException $e) {
            return false;
        }
        return true;
    }

    public static function installExternalCarrier($config)
    {
        try {
            $carrier_id = ((int) (Configuration::get('ID_CARRIER_URBANO'))) ? (int) (Configuration::get('ID_CARRIER_URBANO')) : false;

            if(!$carrier_id){
                $carrier = new Carrier();
                Configuration::updateValue('ID_SHIPPER_URBANO', '1258');
                Configuration::updateValue('KEY_SHIPPER_URBANO', 'XX');
                Configuration::updateValue('ENDPOINT_SERVICIO_URBANO', 'urbano.com.ar');
                Configuration::updateValue('COEFICIENTE_AFORO_URBANO', '4000');
                Configuration::updateValue('IMPORTE_ENVIO_URBANO', '0');
                $carrier->name = $config['name'];
                $carrier->id_tax_rules_group = $config['id_tax_rules_group'];
                $carrier->id_zone = $config['id_zone'];
                $carrier->active = $config['active'];
                $carrier->deleted = $config['deleted'];
                $carrier->delay = $config['delay'];
                $carrier->shipping_handling = $config['shipping_handling'];
                $carrier->range_behavior = $config['range_behavior'];
                $carrier->is_module = $config['is_module'];
                $carrier->shipping_external = $config['shipping_external'];
                $carrier->external_module_name = $config['external_module_name'];
                $carrier->need_range = $config['need_range'];
                $languages = Language::getLanguages(true);
                foreach ($languages as $language) {
                    if ($language['iso_code'] == Language::getIsoById(Configuration::get('PS_LANG_DEFAULT'))) {
                        $carrier->delay[(int) $language['id_lang']] = $config['delay'][$language['iso_code']];
                    }
    
                }
                $carrier->add();
    
                $groups = Group::getGroups(true);
                foreach ($groups as $group) {
                    Db::getInstance()->insert('carrier_group', array('id_carrier' => (int) ($carrier->id), 'id_group' => (int) ($group['id_group'])));
                }    
                
                $rangePrice = new RangePrice();
                $rangePrice->id_carrier = $carrier->id;
                $rangePrice->delimiter1 = '0';
                $rangePrice->delimiter2 = '10000';
                $rangePrice->add();
                $rangeWeight = new RangeWeight();
                $rangeWeight->id_carrier = $carrier->id;
                $rangeWeight->delimiter1 = '0';
                $rangeWeight->delimiter2 = '10000';
                $rangeWeight->add();

                $zones = Zone::getZones(true);
                foreach ($zones as $z) {
                    Db::getInstance()->execute(_DB_PREFIX_ . 'carrier_zone',
                        array('id_carrier' => (int) $carrier->id, 'id_zone' => (int) $z['id_zone']), 'INSERT');
                    Db::getInstance()->execute(_DB_PREFIX_ . 'delivery',
                        array('id_carrier' => $carrier->id, 'id_range_price' => (int) $rangePrice->id, 'id_range_weight' => NULL, 'id_zone' => (int) $z['id_zone'], 'price' => '0'), 'INSERT');
                    Db::getInstance()->execute(_DB_PREFIX_ . 'delivery',
                        array('id_carrier' => $carrier->id, 'id_range_price' => NULL, 'id_range_weight' => (int) $rangeWeight->id, 'id_zone' => (int) $z['id_zone'], 'price' => '0'), 'INSERT');
                }

                $carrier_id = (int) ($carrier->id);
            }else{
                $Carrier1 = new Carrier($carrier_id);
                $Carrier1->deleted = 0;
                $Carrier1->active = 1;
                $Carrier1->update();
            }

            if (!copy(dirname(__FILE__) . '/carrier.jpg', _PS_SHIP_IMG_DIR_ . '/' . (int) $carrier->id . '.jpg')) {
                return false;
            }

            // Return ID Carrier
            return $carrier_id;
        } catch (PrestaShopDatabaseException $e) {
            return false;
        } catch (PrestaShopException $e) {
            return false;
        }
    }

    private function _postValidation()
    {
        if (Tools::isSubmit('btnSubmit')) {
            if (!Tools::getValue('ID_SHIPPER_URBANO') || !Tools::getValue('KEY_SHIPPER_URBANO') || !Tools::getValue('ENDPOINT_SERVICIO_URBANO') || !Tools::getValue('COEFICIENTE_AFORO_URBANO')) {
                $this->_postErrors[] = $this->trans('Es necesario completar el id, llave y endpoint de servicio del cliente.', array(), 'Modules.EnvioUrbano.Admin');
            }

        }
    }

    private function _postProcess()
    {
        if (Tools::isSubmit('btnSubmit')) {
            Configuration::updateValue('ID_SHIPPER_URBANO', Tools::getValue('ID_SHIPPER_URBANO'));
            Configuration::updateValue('KEY_SHIPPER_URBANO', Tools::getValue('KEY_SHIPPER_URBANO'));
            Configuration::updateValue('ENDPOINT_SERVICIO_URBANO', Tools::getValue('ENDPOINT_SERVICIO_URBANO'));
            Configuration::updateValue('COEFICIENTE_AFORO_URBANO', Tools::getValue('COEFICIENTE_AFORO_URBANO'));
            Configuration::updateValue('IMPORTE_ENVIO_URBANO', Tools::getValue('IMPORTE_ENVIO_URBANO'));
        }
        $this->_html .= $this->displayConfirmation($this->trans('Settings updated', array(), 'Admin.Notifications.Success'));
    }

    public function getContent()
    {
        $output = null;

        if (Tools::isSubmit('btnSubmit')) {
            $idShipper = Tools::getValue('ID_SHIPPER_URBANO');
            $apiKey = Tools::getValue('KEY_SHIPPER_URBANO');
            $endpoint = Tools::getValue('ENDPOINT_SERVICIO_URBANO');
            $coeficienteAforo = Tools::getValue('COEFICIENTE_AFORO_URBANO');
            $miOpcion = Tools::getValue('MI_OPCION');
            $importeEnvio = Tools::getValue('IMPORTE_ENVIO_URBANO');

            // Realizar acciones según la opción seleccionada
            if ($miOpcion === 'ware') {
                // Acciones para 'ware'
                $output .= $this->displayConfirmation($this->l('Opción "ware" seleccionada.'));
            } elseif ($miOpcion === 'cross') {
                // Acciones para 'cross'
                $output .= $this->displayConfirmation($this->l('Opción "cross" seleccionada.'));
            }

            Configuration::updateValue('ID_SHIPPER_URBANO', $idShipper);
            Configuration::updateValue('KEY_SHIPPER_URBANO', $apiKey);
            Configuration::updateValue('ENDPOINT_SERVICIO_URBANO', $endpoint);
            Configuration::updateValue('COEFICIENTE_AFORO_URBANO', $coeficienteAforo);
            Configuration::updateValue('MI_OPCION', $miOpcion);
            Configuration::updateValue('IMPORTE_ENVIO_URBANO', $importeEnvio);

            $output .= $this->displayConfirmation($this->l('Configuración guardada correctamente.'));
        }

        return $output.$this->renderForm();
    }

    public function renderForm()
    {
        $fields_form = array(
            'form' => array(
                'legend' => array(
                    'title' => $this->trans('Configuración del Shipper', array(), 'Modules.EnvioUrbano.Admin'),
                ),
                'input' => array(
                    array(
                        'type' => 'text',
                        'label' => $this->trans('Id Shipper', array(), 'Modules.EnvioUrbano.Admin'),
                        'name' => 'ID_SHIPPER_URBANO',
                        'required' => true,
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->trans('Api Key', array(), 'Modules.EnvioUrbano.Admin'),
                        'name' => 'KEY_SHIPPER_URBANO',
                        'required' => true,
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->trans('EndPoint WebService', array(), 'Modules.EnvioUrbano.Admin'),
                        'name' => 'ENDPOINT_SERVICIO_URBANO',
                        'required' => true,
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->trans('Coeficiente Aforo', array(), 'Modules.EnvioUrbano.Admin'),
                        'name' => 'COEFICIENTE_AFORO_URBANO',
                        'required' => true,
                    ),
                    array(
                        'type' => 'radio',
                        'label' => $this->trans('Opción', array(), 'Modules.EnvioUrbano.Admin'),
                        'name' => 'MI_OPCION',
                        'required' => true,
                        'values' => array(
                            array(
                                'id' => 'ware',
                                'value' => 'ware',
                                'label' => $this->trans('Ware', array(), 'Modules.EnvioUrbano.Admin'),
                            ),
                            array(
                                'id' => 'cross',
                                'value' => 'cross',
                                'label' => $this->trans('Cross', array(), 'Modules.EnvioUrbano.Admin'),
                            ),
                        ),
                    ),
                    array(
                        'type' => 'text',
                        'label' => $this->trans('Importe de envio', array(), 'Modules.EnvioUrbano.Admin'),
                        'name' => 'IMPORTE_ENVIO_URBANO',
                        'desc' => $this->trans('En caso de agregar un importe final y personalizado al envío, ingresar un importe. De lo contrario, dejar en blanco o usar 0.', array(), 'Modules.EnvioUrbano.Admin'),
                        'required' => false,
                    ),
                ),
                'submit' => array(
                    'title' => $this->trans('Guardar', array(), 'Admin.Actions'),
                ),
            ),
        );

        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->id = (int) Tools::getValue('id_carrier');
        $helper->identifier = $this->identifier;
        $helper->submit_action = 'btnSubmit';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false) . '&configure=' . $this->name . '&tab_module=' . $this->tab . '&module_name=' . $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = array(
            'fields_value' => array(
                'ID_SHIPPER_URBANO' => Configuration::get('ID_SHIPPER_URBANO', ''),
                'KEY_SHIPPER_URBANO' => Configuration::get('KEY_SHIPPER_URBANO', ''),
                'ENDPOINT_SERVICIO_URBANO' => Configuration::get('ENDPOINT_SERVICIO_URBANO', ''),
                'COEFICIENTE_AFORO_URBANO' => Configuration::get('COEFICIENTE_AFORO_URBANO', ''),
                'MI_OPCION' => Configuration::get('MI_OPCION', ''),
                'IMPORTE_ENVIO_URBANO' => Configuration::get('IMPORTE_ENVIO_URBANO', ''),
            ),
        );

        return $helper->generateForm(array($fields_form));
    }

    public function getConfigFieldsValues()
    {
        return array(
            'ID_SHIPPER_URBANO' => Configuration::get('ID_SHIPPER_URBANO', ''),
            'KEY_SHIPPER_URBANO' => Configuration::get('KEY_SHIPPER_URBANO', ''),
            'ENDPOINT_SERVICIO_URBANO' => Configuration::get('ENDPOINT_SERVICIO_URBANO', ''),
            'COEFICIENTE_AFORO_URBANO' => Configuration::get('COEFICIENTE_AFORO_URBANO', ''),
            'MI_OPCION' => Configuration::get('MI_OPCION', ''),
            'IMPORTE_ENVIO_URBANO' => Configuration::get('IMPORTE_ENVIO_URBANO', ''),
        );
    }

    public function getOrderShippingCost($params, $shipping_cost)
    {

        if ($this->shipping_cost)
            return $this->shipping_cost;

        if ((int) Configuration::get('IMPORTE_ENVIO_URBANO') > 0 )
            return  Configuration::get('IMPORTE_ENVIO_URBANO');

        try {
            $cart = new Cart($params->id);
            $cartProducts = $cart->getProducts();
            $address = new Address((int) $cart->id_address_invoice);
            $pesoEsp = 0;
            $pesoVol = 0;
            $cp = $address->postcode;
            foreach ($cartProducts as $products) {
                if ((isset($products["weight"]) && $products["weight"] > 0) || // Si tiene peso O
                    ((isset($products["width"]) && $products["width"] > 0) && // tenga largo alto ancho
                        (isset($products["height"]) && $products["height"] > 0) &&
                        (isset($products["depth"]) && $products["depth"] > 0) &&
                        ($cp != '' && is_int($cp))) //codigo pestal correcto
                ) {
                    $pesoEsp += $products["weight"] * $products["cart_quantity"];
                    $pesoVol += (($products["width"] * $products["height"] * $products["depth"]) / Configuration::get('COEFICIENTE_AFORO_URBANO')) * $products["cart_quantity"];
                } else {
                    return false;
                }
                // sino sale
            }
            $valorTarifa = false;
            $data = new stdClass();
            // Autentificacion
            $data->autentificacion = new stdClass();
            $data->autentificacion->shipper = Configuration::get('ID_SHIPPER_URBANO');
            $data->autentificacion->password = Configuration::get('KEY_SHIPPER_URBANO');
            $data->codigoPostal = $cp; // Codigo Postal
            $data->pesoEspecifico = round($pesoEsp, 2); // expresado en Kilogramos
            $data->pesoVolumetrico = round($pesoVol, 2); // expresado en Kilogramos
            $data->alto = 0; // en centimetros
            $data->largo = 0; // en centimetros
            $data->ancho = 0; // en centimetros
            $client = new SoapClient('https://' . Configuration::get('ENDPOINT_SERVICIO_URBANO') . '/webservice/?wsdl');

            $response = $client->consultarTarifa($data);

            #Busca costo por zona
            $adicionaPorZona = 0;
            $carrier = new Carrier(Configuration::get('ID_CARRIER_URBANO'));
            $state = new State((int) $address->id_state);
            if($state->id_zone){
                $getCostoRangoZona = round($this->getDeliveryPriceByWeight($data->pesoEspecifico , $state->id_zone , $carrier->id) , 2);         
                if($getCostoRangoZona){
                    $adicionaPorZona = $getCostoRangoZona;
                }
            }            

            $total = $response->valorTarifa + $adicionaPorZona;

            if ($response->codError == 0) {
                if ($this->id_carrier == (int) (Configuration::get('ID_CARRIER_URBANO')) && Configuration::get('FLAG_URBANO')) {
                    $this->shipping_cost = $total;
                } else {
                    $this->shipping_cost = false;
                }
            }

            return (!$this->shipping_cost) ? false : (float) $this->shipping_cost;
        } catch (Exception $e) {
            return false;
        }

    }

    public function getDeliveryPriceByWeight($totalWeight, $id_zone , $id_carrier)
	{
		$result = Db::getInstance()->getRow('
		SELECT d.`price`
		FROM `'._DB_PREFIX_.'delivery` d
		LEFT JOIN `'._DB_PREFIX_.'range_weight` w ON (d.`id_range_weight` = w.`id_range_weight`)
		WHERE d.`id_zone` = '.intval($id_zone).'
		AND '.floatval($totalWeight).' >= w.`delimiter1`
		AND '.floatval($totalWeight).' <= w.`delimiter2`
		AND d.`id_carrier` = '.intval($id_carrier).'
		ORDER BY w.`delimiter1` ASC');
		if (!isset($result['price']))
			return $this->getMaxDeliveryPriceByWeight($id_zone);
		return $result['price'];
	}

    public function getMaxDeliveryPriceByWeight($id_zone)
	{
		$result = Db::getInstance()->ExecuteS('
		SELECT d.`price`
		FROM `'._DB_PREFIX_.'delivery` d
		INNER JOIN `'._DB_PREFIX_.'range_weight` w ON d.`id_range_weight` = w.`id_range_weight`
		WHERE d.`id_zone` = '.intval($id_zone).'
		AND d.`id_carrier` = '.intval($this->id).'
		ORDER BY w.`delimiter2` DESC LIMIT 1');
		if (!isset($result[0]['price']))
			return false;
		return $result[0]['price'];
	}

    public function getOrderShippingCostExternal($params)
    {
        // TODO: Implement getOrderShippingCostExternal() method.
    }

    public function renderWidget($hookName, array $configuration)
    {
        // TODO: Implement renderWidget() method.
    }

    public function getWidgetVariables($hookName, array $configuration)
    {
        // TODO: Implement getWidgetVariables() method.
    }

}
