<?php 
/**
 * @category    UrbanoArg
 * @package     UrbanoArg_Urbano
 * @copyright   Copyright (c) 2015 Urbano Argentina (http://www.urbano.com.ar)
 * @license     http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */
class UrbanoArg_Urbano_Adminhtml_OrdersController extends Mage_Adminhtml_Controller_Action
{
	public function enviarurbanoAction()
	{
		$orderIds = $this->getRequest()->getParam('order_ids');
		foreach ($orderIds as $orderId) {
			$order = Mage::getModel('sales/order')->load($orderId);
			$metodo = $order->getShippingMethod();
			if( $metodo == "urbanoarg_urbano_urbanoarg_urbano") {
              $total_ordered_items = $order->getData('total_qty_ordered');
              $num_of_item_shipped = 0;
              foreach ($order->getAllVisibleItems() as $item)
                 $num_of_item_shipped += $item->getQtyShipped();
              if($num_of_item_shipped >= $total_ordered_items)
                Mage::getSingleton('adminhtml/session')->addError('La orden nro '.$order->getIncrementId().' ya se encuentra enviada por Urbano.');
              else {
				try {
                  $itemQty =  $order->getItemsCollection()->count();
                  $shipment = Mage::getModel('sales/service_order', $order)->prepareShipment($itemQty);
                  $shipment = new Mage_Sales_Model_Order_Shipment_Api();
                  $shipmentId = $shipment->create( $order->getIncrementId(), array(), 'Enviado por Urbano', true, true);
                  Mage::getSingleton('adminhtml/session')->addSuccess('La orden n° '.$order->getIncrementId().' ha generado el pedido de envio en Urbano.');
				}catch (Exception $e) {
                    Mage::log($e);
					Mage::getSingleton('adminhtml/session')->addError('Ha sucedido un error al realizar el pedido de envio de la orden nro '.$order->getIncrementId());
				}
              }
			}else{
				Mage::getSingleton('adminhtml/session')->addError('La orden nro '.$order->getIncrementId().' no tiene a Urbano como metodo de envio.');
			}
		}

		$this->_redirect('adminhtml/sales_order/index');

	}
}

?>
