<?php
/**
 * @category    UrbanoArg
 * @package     UrbanoArg_Urbano
 * @copyright   Copyright (c) 2015 Urbano Argentina (http://www.urbano.com.ar)
 * @license     http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */
class UrbanoArg_Urbano_Adminhtml_EnviosurbanoController extends Mage_Adminhtml_Controller_Action
{

    public function indexAction()
    {
      if($this->getRequest()->isXmlHttpRequest()) {
        $this->getResponse()->setBody($this->getLayout()->createBlock('urbano/adminhtml_enviosurbano_grid')->toHtml());
        return $this;
      }
        $this->loadLayout();
        $this->_addContent($this->getLayout()->createBlock('urbano/adminhtml_enviosurbano'));
        $this->renderLayout();
    }
    
    public function exportCsvAction()
    {
        $fileName = 'envios_urbano.csv';
        $grid = $this->getLayout()->createBlock('urbano/adminhtml_enviosurbano_grid');
        $this->_prepareDownloadResponse($fileName, $grid->getCsvFile());
    }

    public function exportExcelAction()
    {
        $fileName = 'envios_urbano.xls';
        $grid = $this->getLayout()->createBlock('urbano/adminhtml_enviosurbano_grid');
        $this->_prepareDownloadResponse($fileName, $grid->getExcelFile($fileName));
    }

}
?>