<?php
/**
 * @category    UrbanoArg
 * @package     UrbanoArg_Urbano
 * @copyright   Copyright (c) 2015 Urbano Argentina (http://www.urbano.com.ar)
 * @license     http://opensource.org/licenses/osl-3.0.php  Open Software License (OSL 3.0)
 */
class UrbanoArg_Urbano_Model_Carrier
extends Mage_Shipping_Model_Carrier_Abstract
implements Mage_Shipping_Model_Carrier_Interface
{
  protected $_code = 'urbanoarg_urbano';
 
  public function collectRates(Mage_Shipping_Model_Rate_Request $request)
  {
    if (!$this->getConfigData('active'))
      return false;
    if (!Mage::app()->getStore()->isAdmin() && !$this->getConfigData('activeFront'))
      return false;
    $this->_request = $request;
    $result = Mage::getModel('shipping/rate_result');
    $result->append($this->_getDefaultRate());
    return $result;
  }
  
  public function getAllowedMethods()
  {
    return array(
      'urbanoarg_urbano' => $this->getConfigData('name'),
    );
  }
  
  protected function getPrice(){
    // ARMA EL REQUEST CONSLTA TARIFA
    $data = new stdClass();
    // Autentificacion
    $data->autentificacion->shipper = $this->getConfigData('shipUrb');
    $data->autentificacion->password = $this->getConfigData('keyUrb');
    // Codigo Postal
    $data->codigoPostal    = $this->_request->getDestPostcode();
    $data->pesoEspecifico  = $this->getTotalNumOfBoxes($this->_request->getPackageWeight()); // expresado en Kilogramos
    $data->pesoVolumetrico = 0; // expresado en Kilogramos
    $data->alto            = 0;  // en centimetros
    $data->largo           = 0;  // en centimetros
    $data->ancho           = 0;  // en centimetros
    try{
      $client = new SoapClient($this->getConfigData('gateway_url')."?wsdl", array('cache_wsdl' => WSDL_CACHE_NONE));
      $response = $client->consultarTarifa($data);
      if ($response->codError==0)
        return $response->valorTarifa;
      else 
        return -1;
    } catch (Exception $e) { 
        return -1;
    }
  }
  
  protected function _getDefaultRate()
  {
    $rate = Mage::getModel('shipping/rate_result_method');
    $rate->setCarrier($this->_code);
    $rate->setCarrierTitle($this->getConfigData('title'));
    $rate->setMethod($this->_code);
    $rate->setMethodTitle($this->getConfigData('name'));
    if (Mage::app()->getStore()->isAdmin())
      $price=0;
    else{
      $price = $this->getPrice();
      if ($price==-1)
        return false;
    }
    $rate->setPrice($price);
    $rate->setCost(0);
     
    return $rate;
  }
  
  public function getTrackingInfo($tracking)
{
    $track = Mage::getModel('shipping/tracking_result_status');
    $track->setUrl($this->getConfigData('gateway_url') . "cespecifica/?shi_codigo=" . $this->getConfigData('shipUrb') ."&cli_codigo=". $tracking)
        ->setTracking($tracking)
        ->setCarrierTitle("Urbano - Envio regular");
    return $track;
}
  
  public function isTrackingAvailable()
{
    return true;
}

}